(function() {
    var cc_zip = {
        _entries: [],
        _zipArr: [],
        _reader: [],
        _fileName: "",
        _path: "",
        _worker: null,
        getZip: function(e) {
            e.preventDefault();
            cc_zip._zipArr = [];
            if (e.dataTransfer.files[0].type != 'application/zip') {
                alert('格式不正确')
                return false;
            }
            cc_zip._fileName = e.dataTransfer.files[0].name.substr(0, e.dataTransfer.files[0].name.indexOf('.'))
            cc_zip._path = e.dataTransfer.files[0].path;
            ipcRenderer.send('zipParse', { path: cc_zip._path, name: cc_zip._fileName })
            localStorage.removeItem('zipData');
            localStorage.setItem('zipData', JSON.stringify({ path: "/tmp/zip", name: cc_zip._fileName }));
            $('.zipDiv').attr('disable', 'true');
            $('.zipDiv').html('解压缩中');
            ipcRenderer.on('zipParseSucc', function(e, arg) {
                $('.zipDiv').html('转换完成');
                localStorage.removeItem('zipData');
                localStorage.setItem('zipData', JSON.stringify({ path: arg, name: cc_zip._fileName }));
                ipcRenderer.send('zipDateReceive')
            })
            return false;
        },
        admZip: function(files) {
            // let AdmZip = nodeRequire('adm-zip');

            // // reading archives
            // var zip = new AdmZip(files);
            // var zipEntries = zip.getEntries(); // an array of ZipEntry records
            // $('.zipDiv').html('解压缩中');
            // zipEntries.forEach(function(zipEntry) {

            // });
            // console.log(new Date().getTime())	    
            // zip.extractAllTo(`./zip/${cc_zip._fileName}/`, /*overwrite*/false);	
            // $('.zipDiv').html('解压缩完成');
            // console.log(new Date().getTime())
        },
        parseZip: function(e) {
            zip.createReader(new zip.BlobReader(e), function(reader) {
                cc_zip._entries = [];
                cc_zip._reader = reader;
                reader.getEntries(function(entries) {
                    for (let i = 0; i < entries.length; i++) {
                        //				  			if(entries[i].size>0){
                        cc_zip._entries.push(entries[i])
                            //				  			}
                    }
                    //				  		cc_zip._entries=entries;
                    cc_zip.progressEnpty();
                });
            }, function(error) {
                // onerror callback
                console.log(error)
            });
        },
        showTest: function(txt) {
            cc_zip._zipArr[cc_zip._zipArr.length - 1].setValue(txt);
            cc_zip.progressEnpty();
        },
        showBlob: function(txt) {
            cc_zip._zipArr[cc_zip._zipArr.length - 1].setValue(txt);
            cc_zip.progressEnpty();
        },
        uintToString: function(uintArray) {
            var encodedString = String.fromCharCode.apply(null, uintArray);
            console.log('第一步', encodedString, new Date().getTime());
            return encodedString;
        },
        blobToUint8: function(blob, cb) {
            let reader = new FileReader();
            reader.onload = function(e) {
                let u8 = new Uint8Array(e.target.result);
                cb(cc_zip.uintToString(u8));
            };
            reader.readAsArrayBuffer(blob);
        },
        blobToArray: function(blob, cb) {
            let reader = new FileReader();
            reader.onload = function(e) {
                let u8 = new Uint8Array(e.target.result);
                cb(u8);
            };
            reader.readAsArrayBuffer(blob);
        },
        progressEnpty: function() {
            if (cc_zip._entries.length > 0) {
                let en = cc_zip._entries.shift();
                let cd = new cc_data();
                cd.setName(en.filename);
                cc_zip._zipArr.push(cd);
                if (en.filename.indexOf('.json') != -1) {
                    if (en.filename.indexOf('__MACOSX') != -1) {
                        cc_zip._zipArr.pop()
                        cc_zip.progressEnpty();
                        return;
                    } else {
                        cd.setType('json');
                    }

                } else if (en.filename.indexOf('.mp4') != -1) {
                    cd.setType('mp4');
                }
                en.getData(new zip.BlobWriter(), function(text) {
                    console.log("text", text.size, new Date().getTime());
                    if (text.size == 0) {
                        cc_zip._zipArr.pop()
                        cc_zip.progressEnpty();
                    }
                    if (cd.type == 'json') {
                        cc_zip.blobToUint8(text, cc_zip.showTest);
                    } else if (cd.type == 'mp4') {
                        //						cd.setValue(text);
                        //						
                        //						cc_zip.progressEnpty();
                        cc_zip.blobToArray(text, cc_zip.showBlob);
                    }

                }, function(current, total) {
                    console.log("text2", current / total);
                    $('#progress').css('width', parseInt(current / total * 100) + "%");
                });
            } else {
                cc_zip._reader.close(function() {
                    //					console.log(JSON.stringify(cc_zip._zipArr))
                    //					localStorage.removeItem('zipdata');
                    //					localStorage.setItem('zipdata',JSON.stringify(cc_zip._zipArr));
                    //					ipcRenderer.send('zipDateReceive')
                    //					openDB('cc_zipdata');
                    console.log(cc_zip._zipArr, '关闭成功')
                })
            }
        }
    };
    window.cc_zip = cc_zip;
})()
var myDB = {};

function openDB(name) {
    var request = window.indexedDB.open(name);
    request.onerror = function(e) {
        console.log('OPen Error!');
    };
    request.onsuccess = function(e) {
        myDB.db = e.target.result;
        store = myDB.db.createObjectStore("cc_zipdata", {
            keyPath: "username"
        });
        put(cc_zip._zipArr, 1)
    };
};
put = function(params, key) {
    //此处须显式声明事物  
    var transaction = myDB.db.transaction('cc_zipdata', "readwrite");
    var store = transaction.objectStore('cc_zipdata');
    var request = store.put(params, key);
    request.onsuccess = function() {
        alert('添加成功');
    };
    request.onerror = function(event) {
        console.log(event);
    }
};

const ipcRenderer = nodeRequire('electron').ipcRenderer;

function cc_data() {
    this.type;
    this.value;
    this.name;
};
cc_data.prototype.setType = function(t) {
    this.type = t;
};
cc_data.prototype.setValue = function(t) {
    this.value = t;
};
cc_data.prototype.setName = function(t) {
    this.name = t;
};